/*
 * Decompiled with CFR 0.152.
 */
package net.smart.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import net.smart.core.SmartCoreMethodVisitor;
import net.smart.core.SmartCoreTransformation;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public final class SmartCoreClassVisitor
extends ClassVisitor {
    private final List<SmartCoreTransformation> transformations;

    public static byte[] transform(byte[] bytes, List<SmartCoreTransformation> transformations) {
        try {
            ByteArrayInputStream in = new ByteArrayInputStream(bytes);
            ClassReader cr = new ClassReader((InputStream)in);
            ClassWriter cw = new ClassWriter(1);
            SmartCoreClassVisitor p = new SmartCoreClassVisitor((ClassVisitor)cw, transformations);
            cr.accept((ClassVisitor)p, 0);
            byte[] result = cw.toByteArray();
            in.close();
            return result;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public SmartCoreClassVisitor(ClassVisitor classVisitor, List<SmartCoreTransformation> transformations) {
        super(262144, classVisitor);
        this.transformations = transformations;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor base = super.visitMethod(access, name, desc, signature, exceptions);
        for (SmartCoreTransformation transformation : this.transformations) {
            if (!name.equals(transformation.methodName) || !desc.equals(transformation.getMethodDesc())) continue;
            return new SmartCoreMethodVisitor(base, transformation);
        }
        return base;
    }
}

